unit Demomisc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VisApp, Feedback, Ledgadgt, Balloon, MMGadget, StdCtrls,
  ExtCtrls, Custbtn;

type
  TMiscGadgets = class(TForm)
    LEDLabel1: TLEDLabel;
    CheckBox2: TCheckBox;
    RotaryKnob1: TRotaryKnob;
    PieMeter1: TPieMeter;
    CheckBox3: TCheckBox;
    Image1: TImage;
    RadioGroup1: TRadioGroup;
    NeatoMeter1: TNeatoMeter;
    Image2: TImage;
    RadioGroup2: TRadioGroup;
    ShadowButton1: TShadowButton;
    procedure RotaryKnob1Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MiscGadgets: TMiscGadgets;

implementation

{$R *.DFM}

procedure TMiscGadgets.RotaryKnob1Change(Sender: TObject);
begin
  NeatoMeter1.Completed := RotaryKnob1.Position;
  PieMeter1.Completed := RotaryKnob1.Position;
end;

procedure TMiscGadgets.CheckBox2Click(Sender: TObject);
var
  s: String;
begin
  if CheckBox2.Checked then
    s := 'Hi!'
  else
    s := '';
  NeatoMeter1.Caption := s;
  PieMeter1.Caption := s;
end;

procedure TMiscGadgets.CheckBox3Click(Sender: TObject);
begin
  NeatoMeter1.ShowPercent := CheckBox3.Checked;
  PieMeter1.ShowPercent := CheckBox3.Checked;
end;

procedure TMiscGadgets.RadioGroup2Click(Sender: TObject);
begin
  NeatoMeter1.Direction := TMeterDirection(RadioGroup2.ItemIndex);
end;

procedure TMiscGadgets.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
    0:  NeatoMeter1.Bitmap := nil;
    1:
      begin
        CheckBox2.Checked := False;
        CheckBox3.Checked := False;
        NeatoMeter1.Bitmap := Image2.Picture.Bitmap;
        NeatoMeter1.BitmapDrawStyle := dsStretch;
      end;
    2:
      begin
        NeatoMeter1.Bitmap := Image1.Picture.Bitmap;
        NeatoMeter1.BitmapDrawStyle := dsTile;
      end;
    3:
      begin
        NeatoMeter1.Bitmap := Image1.Picture.Bitmap;
        NeatoMeter1.BitmapDrawStyle := dsTileInvert;
      end;
  end;
end;

end.
